/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.gui;

import com.lycanitesmobs.AssetManager;
import com.lycanitesmobs.core.entity.EntityCreatureBase;
import com.lycanitesmobs.core.gui.GUIBaseManager;
import com.lycanitesmobs.core.gui.GUISummoningPedestalList;
import com.lycanitesmobs.core.gui.GUITabMain;
import com.lycanitesmobs.core.tileentity.TileEntitySummoningPedestal;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.translation.I18n;
import org.lwjgl.opengl.GL11;

public class GUISummoningPedestal
extends GUIBaseManager {
    public TileEntitySummoningPedestal summoningPedestal;

    public GUISummoningPedestal(EntityPlayer player, TileEntitySummoningPedestal summoningPedestal) {
        super(player, "minion");
        this.summoningPedestal = summoningPedestal;
        this.summonSet = this.summoningPedestal.summonSet;
    }

    @Override
    public void initList() {
        if (this.hasPets() && this.summoningPedestal.summonSet != null) {
            this.selectMinion(this.summoningPedestal.summonSet.summonType);
        }
        int buttonSpacing = 2;
        int listWidth = this.windowWidth / 2 - buttonSpacing * 4;
        int listHeight = this.windowHeight - (39 + buttonSpacing) - 16;
        int listTop = this.windowY + 39 + buttonSpacing;
        int listBottom = listTop + listHeight;
        int listX = this.windowX + buttonSpacing * 2;
        this.list = new GUISummoningPedestalList(this, this.playerExt, listWidth, listHeight, listTop, listBottom, listX);
        this.list.registerScrollButtons(this.field_146292_n, 51, 52);
    }

    @Override
    public String getTitle() {
        return I18n.func_74838_a((String)"gui.summoningpedestal.name");
    }

    @Override
    public String getEnergyTitle() {
        return I18n.func_74838_a((String)"stat.portal.name");
    }

    @Override
    public void drawEnergyBar() {
        int energyBarWidth = 9;
        int energyBarHeight = 9;
        int energyBarX = this.windowX + 16;
        int energyBarY = this.windowY + 40 - energyBarHeight;
        int energyBarU = 256 - energyBarWidth;
        int energyBarV = 256 - energyBarHeight;
        for (int energyBarEnergyN = 1; energyBarEnergyN <= 10; ++energyBarEnergyN) {
            this.func_73729_b(energyBarX - energyBarWidth + energyBarWidth * energyBarEnergyN, energyBarY, energyBarU, energyBarV, energyBarWidth, energyBarHeight);
            if (this.summoningPedestal.capacity >= energyBarEnergyN * this.summoningPedestal.capacityCharge) {
                this.func_73729_b(energyBarX - energyBarWidth + energyBarWidth * energyBarEnergyN, energyBarY, energyBarU - energyBarWidth * 2, energyBarV, energyBarWidth, energyBarHeight);
                continue;
            }
            if (this.summoningPedestal.capacity + this.summoningPedestal.capacityCharge <= energyBarEnergyN * this.summoningPedestal.capacityCharge) continue;
            float spiritChargeScale = (float)(this.summoningPedestal.capacity % this.summoningPedestal.capacityCharge) / (float)this.summoningPedestal.capacityCharge;
            this.func_73729_b(energyBarX - energyBarWidth + energyBarWidth * energyBarEnergyN, energyBarY, energyBarU - energyBarWidth * 2, energyBarV, Math.round((float)energyBarWidth * spiritChargeScale), energyBarHeight);
        }
    }

    @Override
    public void drawHealthBar() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.field_146297_k.func_110434_K().func_110577_a(AssetManager.getTexture("GUIInventoryCreature"));
        int barWidth = 80;
        int barHeight = 11;
        int barX = this.centerX + 2;
        int barY = this.windowY + 26;
        int barU = 144;
        int barV = 256 - barHeight * 2;
        this.func_73729_b(barX, barY, barU, barV, barWidth, barHeight);
        barWidth = Math.round((float)barWidth * ((float)this.summoningPedestal.summonProgress / (float)this.summoningPedestal.summonProgressMax));
        this.func_73729_b(barX, barY, barU, barV += barHeight, barWidth, barHeight);
    }

    @Override
    protected void drawControls() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int buttonSpacing = 2;
        int buttonWidth = this.windowWidth / 4 - buttonSpacing * 2;
        int buttonHeight = 20;
        int buttonX = this.windowX + 6;
        int buttonY = this.windowY;
        this.field_146292_n.add(new GUITabMain(tabButtonID, buttonX, buttonY - 24));
        buttonX = this.centerX + buttonSpacing;
        int buttonXRight = buttonX + buttonWidth + buttonSpacing;
        buttonY = this.windowY + 39 + buttonSpacing;
        this.field_146292_n.add(new GuiButton((int)EntityCreatureBase.GUI_COMMAND_ID.SITTING.id, buttonX, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth * 2, buttonHeight, "..."));
        this.field_146292_n.add(new GuiButton((int)EntityCreatureBase.GUI_COMMAND_ID.PASSIVE.id, buttonX, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth, buttonHeight, "..."));
        this.field_146292_n.add(new GuiButton((int)EntityCreatureBase.GUI_COMMAND_ID.STANCE.id, buttonXRight, buttonY, buttonWidth, buttonHeight, "..."));
        this.field_146292_n.add(new GuiButton((int)EntityCreatureBase.GUI_COMMAND_ID.PVP.id, buttonX, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth * 2, buttonHeight, "..."));
    }

    @Override
    public void updateButtons(GuiButton button) {
        if (button.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.SITTING.id) {
            button.field_146126_j = I18n.func_74838_a((String)"gui.pet.sitting") + ": " + (this.summonSet.getSitting() ? I18n.func_74838_a((String)"common.yes") : I18n.func_74838_a((String)"common.no"));
        }
        if (button.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.PASSIVE.id) {
            button.field_146126_j = I18n.func_74838_a((String)"gui.pet.passive") + ": " + (this.summonSet.getPassive() ? I18n.func_74838_a((String)"common.yes") : I18n.func_74838_a((String)"common.no"));
        }
        if (button.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.STANCE.id) {
            String string = button.field_146126_j = this.summonSet.getAggressive() ? I18n.func_74838_a((String)"gui.pet.aggressive") : I18n.func_74838_a((String)"gui.pet.defensive");
        }
        if (button.field_146127_k == EntityCreatureBase.GUI_COMMAND_ID.PVP.id) {
            button.field_146126_j = I18n.func_74838_a((String)"gui.pet.pvp") + ": " + (this.summonSet.getPVP() ? I18n.func_74838_a((String)"common.yes") : I18n.func_74838_a((String)"common.no"));
        }
        if ("mount".equals(this.type) && button.field_146127_k >= EntityCreatureBase.GUI_COMMAND_ID.SITTING.id && button.field_146127_k <= EntityCreatureBase.GUI_COMMAND_ID.PVP.id) {
            button.field_146124_l = false;
            button.field_146125_m = false;
        }
    }

    @Override
    public void sendCommandsToServer() {
        this.summoningPedestal.sendSummonSetToServer(this.summonSet);
    }

    @Override
    public void selectMinion(String minionName) {
        if (this.summonSet == null) {
            if (this.summoningPedestal == null || this.summoningPedestal.summonSet == null) {
                return;
            }
            this.summonSet = this.summoningPedestal.summonSet;
        }
        this.summonSet.setSummonType(minionName);
        this.sendCommandsToServer();
    }

    @Override
    public boolean hasPets() {
        return this.playerExt.getBeastiary().getSummonableList().size() > 0;
    }

    @Override
    public boolean hasSelectedPet() {
        return this.hasPets() && this.summonSet != null && !this.summonSet.summonType.equals("");
    }

    @Override
    protected ResourceLocation getTexture() {
        return AssetManager.getTexture("GUIMinionLg");
    }
}

